/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.application.dto;

import com.aec.api.application.dto.EnderecoRequestDto;
import com.aec.api.domain.model.Empresa;
import com.aec.api.shared.util.CNPJUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public class EmpresaRequestDto {
    private String razaoSocial;
    private String cnpj;
    private String logo;
    private String statusId;
    private String grupoEmpresaId;
    private List<EnderecoRequestDto> enderecos;

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String razaoSocial) {
        this.razaoSocial = razaoSocial;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public String getGrupoEmpresaId() {
        return this.grupoEmpresaId;
    }

    public void setGrupoEmpresaId(String grupoEmpresaId) {
        this.grupoEmpresaId = grupoEmpresaId;
    }

    public List<EnderecoRequestDto> getEnderecos() {
        return this.enderecos;
    }

    public void setEnderecos(List<EnderecoRequestDto> enderecos) {
        this.enderecos = enderecos;
    }

    public Empresa toModel() {
        Empresa empresa = new Empresa();
        empresa.setRazaoSocial(this.razaoSocial);
        empresa.setCnpj(this.cnpj != null ? this.cnpj.replaceAll("[^\\d]", "") : null);
        if (this.logo != null && !this.logo.isEmpty()) {
            try {
                empresa.setLogo(Base64.getDecoder().decode(this.logo));
            }
            catch (IllegalArgumentException e) {
                empresa.setLogo(null);
            }
        }
        return empresa;
    }

    public List<String> validate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.razaoSocial == null || this.razaoSocial.isEmpty()) {
            errors.add("Raz\u00e3o Social \u00e9 obrigat\u00f3ria");
        }
        if (this.cnpj == null || this.cnpj.isEmpty()) {
            errors.add("CNPJ \u00e9 obrigat\u00f3rio");
        } else if (!CNPJUtil.isValid((String)this.cnpj)) {
            errors.add("CNPJ inv\u00e1lido");
        }
        if (this.statusId == null || this.statusId.isEmpty()) {
            errors.add("Status \u00e9 obrigat\u00f3rio");
        }
        return errors;
    }
}

