/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.application.dto;

import com.aec.api.application.dto.EnderecoResponseDto;
import com.aec.api.application.dto.GrupoEmpresaResponseDto;
import com.aec.api.application.dto.StatusResponseDto;
import com.aec.api.domain.model.Empresa;
import java.util.Base64;
import java.util.List;

public class EmpresaResponseDto {
    private String id;
    private String razaoSocial;
    private String cnpj;
    private String logo;
    private StatusResponseDto status;
    private GrupoEmpresaResponseDto grupoEmpresa;
    private List<EnderecoResponseDto> enderecos;

    public EmpresaResponseDto() {
    }

    public EmpresaResponseDto(Empresa empresa) {
        this.id = empresa.getUuid();
        this.razaoSocial = empresa.getRazaoSocial();
        this.cnpj = empresa.getCnpj();
        if (empresa.getLogo() != null) {
            this.logo = Base64.getEncoder().encodeToString(empresa.getLogo());
        }
        this.status = new StatusResponseDto(empresa.getStatus());
        if (empresa.getGrupoEmpresa() != null) {
            this.grupoEmpresa = new GrupoEmpresaResponseDto(empresa.getGrupoEmpresa());
        }
        this.enderecos = empresa.getEnderecos().stream().map(EnderecoResponseDto::new).toList();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String razaoSocial) {
        this.razaoSocial = razaoSocial;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public StatusResponseDto getStatus() {
        return this.status;
    }

    public void setStatus(StatusResponseDto status) {
        this.status = status;
    }

    public GrupoEmpresaResponseDto getGrupoEmpresa() {
        return this.grupoEmpresa;
    }

    public void setGrupoEmpresa(GrupoEmpresaResponseDto grupoEmpresa) {
        this.grupoEmpresa = grupoEmpresa;
    }

    public List<EnderecoResponseDto> getEnderecos() {
        return this.enderecos;
    }

    public void setEnderecos(List<EnderecoResponseDto> enderecos) {
        this.enderecos = enderecos;
    }
}

