/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.application.dto;

import com.aec.api.domain.model.Usuario;
import com.aec.api.shared.util.CPFUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class UsuarioRequestDto {
    private String nome;
    private String email;
    private String senha;
    private String cargo;
    private String cpf;
    private String statusId;
    private Date dataNascimento;
    private List<String> grupos;

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public String getCargo() {
        return this.cargo;
    }

    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    public String getCpf() {
        return this.cpf.replaceAll("[^\\d]", "");
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public Usuario toModel() {
        Usuario usuario = new Usuario();
        usuario.setNome(this.nome);
        usuario.setEmail(this.email);
        usuario.setSenha(this.senha);
        usuario.setCargo(this.cargo);
        usuario.setCpf(this.cpf.replaceAll("[^\\d]", ""));
        usuario.setDataNascimento(this.dataNascimento);
        return usuario;
    }

    public List<String> validate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.nome == null || this.nome.isEmpty()) {
            errors.add("Nome \u00e9 obrigat\u00f3rio");
        }
        if (this.email == null || this.email.isEmpty()) {
            errors.add("Email \u00e9 obrigat\u00f3rio");
        }
        if (this.senha == null || this.senha.isEmpty()) {
            errors.add("Senha \u00e9 obrigat\u00f3ria");
        }
        if (this.cpf == null || this.cpf.isEmpty()) {
            errors.add("CPF \u00e9 obrigat\u00f3rio");
        } else if (!CPFUtil.isValid((String)this.cpf)) {
            errors.add("CPF inv\u00e1lido");
        }
        if (this.statusId == null || this.statusId.isEmpty()) {
            errors.add("Status \u00e9 obrigat\u00f3rio");
        }
        if (this.dataNascimento == null) {
            errors.add("Data de Nascimento \u00e9 obrigat\u00f3ria");
        }
        return errors;
    }

    public List<String> getGrupos() {
        return this.grupos;
    }

    public void setGrupos(List<String> grupos) {
        this.grupos = grupos;
    }
}

