/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.application.dto;

import com.aec.api.application.dto.GrupoResponseDto;
import com.aec.api.application.dto.StatusResponseDto;
import com.aec.api.domain.model.Grupo;
import com.aec.api.domain.model.Usuario;
import java.util.Date;
import java.util.List;

public class UsuarioResponseDto {
    private String id;
    private String nome;
    private String email;
    private String cargo;
    private String cpf;
    private Date dataNascimento;
    private StatusResponseDto status;
    private List<GrupoResponseDto> grupos;

    public UsuarioResponseDto(Usuario usuario) {
        this.id = usuario.getUuid();
        this.nome = usuario.getNome();
        this.email = usuario.getEmail();
        this.cargo = usuario.getCargo();
        this.cpf = usuario.getCpf();
        this.status = new StatusResponseDto(usuario.getStatus());
        this.dataNascimento = usuario.getDataNascimento();
        List<Grupo> usuariosGrupos = usuario.getUsuarioGrupos().stream().map(ug -> ug.getGrupo()).toList();
        this.grupos = usuariosGrupos.stream().map(GrupoResponseDto::new).toList();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCargo() {
        return this.cargo;
    }

    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public StatusResponseDto getStatus() {
        return this.status;
    }

    public void setStatus(StatusResponseDto status) {
        this.status = status;
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public List<GrupoResponseDto> getGrupos() {
        return this.grupos;
    }

    public void setGrupos(List<GrupoResponseDto> grupos) {
        this.grupos = grupos;
    }
}

