/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.application.service;

import com.aec.api.application.dto.CredenciaisRequestDto;
import com.aec.api.application.dto.GrupoTokenResponseDto;
import com.aec.api.application.dto.RoleTokenResponseDto;
import com.aec.api.application.dto.TokenResponseDto;
import com.aec.api.application.service.exceptions.UsuarioOuSenhaInvalidoException;
import com.aec.api.application.service.interfaces.AuthService;
import com.aec.api.domain.model.Usuario;
import com.aec.api.domain.repository.UsuariosRepository;
import com.aec.api.infrastructure.config.JWTConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthServiceImpl
implements AuthService {
    @Autowired
    private UsuariosRepository usuariosRepository;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private JWTConfig jwtConfig;

    @Transactional(readOnly=true)
    public TokenResponseDto authenticate(CredenciaisRequestDto credenciais) throws UsuarioOuSenhaInvalidoException {
        Usuario usuario = this.usuariosRepository.findByEmail(credenciais.getEmail());
        if (usuario == null) {
            throw new UsuarioOuSenhaInvalidoException();
        }
        List<GrupoTokenResponseDto> gruposResponseDto = usuario.getUsuarioGrupos().stream().map(ug -> new GrupoTokenResponseDto(ug.getGrupo())).toList();
        ArrayList rolesResponseDto = new ArrayList();
        gruposResponseDto.stream().forEach(gr -> rolesResponseDto.addAll(gr.getRoles()));
        HashMap<String, List<Object>> claims = new HashMap<String, List<Object>>();
        claims.put("permissions", gruposResponseDto);
        claims.put("roles", rolesResponseDto.stream().map(RoleTokenResponseDto::getDescricao).toList());
        List<SimpleGrantedAuthority> authorities = rolesResponseDto.stream().map(role -> new SimpleGrantedAuthority("ROLE_" + role.getDescricao())).toList();
        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)credenciais.getEmail(), (Object)credenciais.getSenha(), authorities);
        this.authenticationManager.authenticate((Authentication)authToken);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authToken);
        String token = this.jwtConfig.generateToken(credenciais.getEmail(), claims);
        return new TokenResponseDto(credenciais.getEmail(), token);
    }

    public TokenResponseDto refresh() throws UsuarioOuSenhaInvalidoException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String email = authentication.getName();
        Usuario usuario = this.usuariosRepository.findByEmail(email);
        if (usuario == null) {
            throw new UsuarioOuSenhaInvalidoException();
        }
        List<GrupoTokenResponseDto> gruposResponseDto = usuario.getUsuarioGrupos().stream().map(ug -> new GrupoTokenResponseDto(ug.getGrupo())).toList();
        ArrayList rolesResponseDto = new ArrayList();
        gruposResponseDto.stream().forEach(gr -> rolesResponseDto.addAll(gr.getRoles()));
        HashMap<String, List<Object>> claims = new HashMap<String, List<Object>>();
        claims.put("permissions", gruposResponseDto);
        claims.put("roles", rolesResponseDto.stream().map(RoleTokenResponseDto::getDescricao).toList());
        String token = this.jwtConfig.generateToken(email, claims);
        return new TokenResponseDto(email, token);
    }
}

