/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.application.service;

import com.aec.api.application.dto.EmpresaRequestDto;
import com.aec.api.application.dto.EmpresaResponseDto;
import com.aec.api.application.dto.EnderecoRequestDto;
import com.aec.api.application.service.exceptions.ObjetoNaoEncontradoException;
import com.aec.api.application.service.exceptions.RequisicaoInvalidaException;
import com.aec.api.application.service.interfaces.EmpresaService;
import com.aec.api.domain.model.Cidade;
import com.aec.api.domain.model.Empresa;
import com.aec.api.domain.model.Endereco;
import com.aec.api.domain.model.GrupoEmpresa;
import com.aec.api.domain.model.Status;
import com.aec.api.domain.repository.CidadeRepository;
import com.aec.api.domain.repository.EmpresaRepository;
import com.aec.api.domain.repository.EnderecoRepository;
import com.aec.api.domain.repository.GrupoEmpresaRepository;
import com.aec.api.domain.repository.StatusRepository;
import jakarta.transaction.Transactional;
import java.util.Base64;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmpresaServiceImpl
implements EmpresaService {
    @Autowired
    private EmpresaRepository empresaRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private GrupoEmpresaRepository grupoEmpresaRepository;
    @Autowired
    private EnderecoRepository enderecoRepository;
    @Autowired
    private CidadeRepository cidadeRepository;

    @Transactional
    public void criarEmpresa(EmpresaRequestDto empresaRequestDto) throws RequisicaoInvalidaException, ObjetoNaoEncontradoException {
        List mensagensErro = empresaRequestDto.validate();
        if (!mensagensErro.isEmpty()) {
            throw new RequisicaoInvalidaException(mensagensErro);
        }
        Status status = this.statusRepository.findByUuid(empresaRequestDto.getStatusId());
        if (status == null) {
            throw new ObjetoNaoEncontradoException("Status informado n\u00e3o existe.");
        }
        GrupoEmpresa grupoEmpresa = this.grupoEmpresaRepository.findByUuid(empresaRequestDto.getGrupoEmpresaId());
        String cnpjNumeros = empresaRequestDto.getCnpj().replaceAll("[^\\d]", "");
        Empresa empresaExistente = this.empresaRepository.findByCnpj(cnpjNumeros);
        if (empresaExistente != null) {
            throw new RequisicaoInvalidaException(List.of("CNPJ j\u00e1 cadastrado."));
        }
        Empresa empresa = empresaRequestDto.toModel();
        if (empresaRequestDto.getLogo() != null && !empresaRequestDto.getLogo().isEmpty()) {
            empresa.setLogo(this.processarLogoBase64(empresaRequestDto.getLogo()));
        }
        empresa.setStatus(status);
        if (grupoEmpresa != null) {
            empresa.setGrupoEmpresa(grupoEmpresa);
        }
        this.empresaRepository.save((Object)empresa);
        if (empresaRequestDto.getEnderecos() != null && !empresaRequestDto.getEnderecos().isEmpty()) {
            for (EnderecoRequestDto enderecoDto : empresaRequestDto.getEnderecos()) {
                this.adicionarEndereco(enderecoDto, empresa);
            }
        }
    }

    public List<EmpresaResponseDto> listarEmpresas() {
        List empresas = this.empresaRepository.findAllByOrderByRazaoSocialAsc();
        return empresas.stream().map(EmpresaResponseDto::new).toList();
    }

    public EmpresaResponseDto buscarEmpresaPorId(String id) throws ObjetoNaoEncontradoException {
        Empresa empresa = this.empresaRepository.findByUuid(id);
        if (empresa == null) {
            throw new ObjetoNaoEncontradoException("Empresa n\u00e3o encontrada.");
        }
        return new EmpresaResponseDto(empresa);
    }

    @Transactional
    public void atualizarEmpresa(String id, EmpresaRequestDto empresaRequestDto) throws ObjetoNaoEncontradoException, RequisicaoInvalidaException {
        String cnpjNumeros;
        Empresa empresaExistente;
        Empresa empresa = this.empresaRepository.findByUuid(id);
        if (empresa == null) {
            throw new ObjetoNaoEncontradoException("Empresa n\u00e3o encontrada.");
        }
        List mensagensErro = empresaRequestDto.validate();
        if (!mensagensErro.isEmpty()) {
            throw new RequisicaoInvalidaException(mensagensErro);
        }
        Status status = this.statusRepository.findByUuid(empresaRequestDto.getStatusId());
        if (status == null) {
            throw new ObjetoNaoEncontradoException("Status informado n\u00e3o existe.");
        }
        GrupoEmpresa grupoEmpresa = this.grupoEmpresaRepository.findByUuid(empresaRequestDto.getGrupoEmpresaId());
        if (grupoEmpresa != null) {
            empresa.setGrupoEmpresa(grupoEmpresa);
        }
        if ((empresaExistente = this.empresaRepository.findByCnpj(cnpjNumeros = empresaRequestDto.getCnpj().replaceAll("[^\\d]", ""))) != null && !empresaExistente.getId().equals(empresa.getId())) {
            throw new RequisicaoInvalidaException(List.of("CNPJ j\u00e1 cadastrado em outra empresa."));
        }
        empresa.setRazaoSocial(empresaRequestDto.getRazaoSocial());
        empresa.setCnpj(cnpjNumeros);
        empresa.setLogo(this.processarLogoBase64(empresaRequestDto.getLogo()));
        empresa.setStatus(status);
        this.empresaRepository.save((Object)empresa);
        this.enderecoRepository.deleteByEmpresaId(empresa.getId());
        if (empresaRequestDto.getEnderecos() != null && !empresaRequestDto.getEnderecos().isEmpty()) {
            for (EnderecoRequestDto enderecoDto : empresaRequestDto.getEnderecos()) {
                this.adicionarEndereco(enderecoDto, empresa);
            }
        }
    }

    private void adicionarEndereco(EnderecoRequestDto enderecoDto, Empresa empresa) throws ObjetoNaoEncontradoException {
        Cidade cidade = this.cidadeRepository.findByUuid(enderecoDto.getCidadeId());
        if (cidade == null) {
            throw new ObjetoNaoEncontradoException("Cidade informada n\u00e3o existe.");
        }
        Endereco endereco = new Endereco();
        endereco.setEndereco(enderecoDto.getEndereco());
        endereco.setNumero(enderecoDto.getNumero());
        endereco.setBairro(enderecoDto.getBairro());
        endereco.setCep(enderecoDto.getCep() != null ? enderecoDto.getCep().replaceAll("[^\\d]", "") : null);
        endereco.setCidade(cidade);
        endereco.setEmpresa(empresa);
        this.enderecoRepository.save((Object)endereco);
    }

    private byte[] processarLogoBase64(String logoBase64) {
        try {
            int commaIndex;
            String base64Data = logoBase64;
            if (logoBase64 == null || logoBase64.isEmpty()) {
                return null;
            }
            if (logoBase64.startsWith("data:") && (commaIndex = logoBase64.indexOf(44)) != -1) {
                base64Data = logoBase64.substring(commaIndex + 1);
            }
            return Base64.getDecoder().decode(base64Data);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

