/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.application.service;

import com.aec.api.application.dto.GrupoEmpresaRequestDto;
import com.aec.api.application.dto.GrupoEmpresaResponseDto;
import com.aec.api.application.service.exceptions.ObjetoNaoEncontradoException;
import com.aec.api.application.service.exceptions.RequisicaoInvalidaException;
import com.aec.api.application.service.interfaces.GrupoEmpresaService;
import com.aec.api.domain.model.GrupoEmpresa;
import com.aec.api.domain.model.Status;
import com.aec.api.domain.repository.GrupoEmpresaRepository;
import com.aec.api.domain.repository.StatusRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GrupoEmpresaServiceImpl
implements GrupoEmpresaService {
    @Autowired
    private GrupoEmpresaRepository grupoEmpresaRepository;
    @Autowired
    private StatusRepository statusRepository;

    public void criarGrupoEmpresa(GrupoEmpresaRequestDto grupoEmpresaRequestDto) throws RequisicaoInvalidaException, ObjetoNaoEncontradoException {
        List mensagensErro = grupoEmpresaRequestDto.validate();
        if (!mensagensErro.isEmpty()) {
            throw new RequisicaoInvalidaException(mensagensErro);
        }
        Status status = this.statusRepository.findByUuid(grupoEmpresaRequestDto.getStatusId());
        if (status == null) {
            throw new ObjetoNaoEncontradoException("Status informado n\u00e3o existe.");
        }
        String raizNumero = grupoEmpresaRequestDto.getRaiz().replaceAll("[^\\d]", "");
        GrupoEmpresa grupoExistente = this.grupoEmpresaRepository.findByRaiz(raizNumero);
        if (grupoExistente != null) {
            throw new RequisicaoInvalidaException(List.of("Raiz j\u00e1 cadastrada."));
        }
        GrupoEmpresa grupoEmpresa = grupoEmpresaRequestDto.toModel();
        grupoEmpresa.setStatus(status);
        this.grupoEmpresaRepository.save((Object)grupoEmpresa);
    }

    public List<GrupoEmpresaResponseDto> listarGruposEmpresa() {
        List gruposEmpresa = this.grupoEmpresaRepository.findAllByOrderByNomeAsc();
        return gruposEmpresa.stream().map(GrupoEmpresaResponseDto::new).toList();
    }

    public GrupoEmpresaResponseDto buscarGrupoEmpresaPorId(String id) throws ObjetoNaoEncontradoException {
        GrupoEmpresa grupoEmpresa = this.grupoEmpresaRepository.findByUuid(id);
        if (grupoEmpresa == null) {
            throw new ObjetoNaoEncontradoException("Grupo Empresa n\u00e3o encontrado.");
        }
        return new GrupoEmpresaResponseDto(grupoEmpresa);
    }

    public void atualizarGrupoEmpresa(String id, GrupoEmpresaRequestDto grupoEmpresaRequestDto) throws ObjetoNaoEncontradoException, RequisicaoInvalidaException {
        GrupoEmpresa grupoEmpresa = this.grupoEmpresaRepository.findByUuid(id);
        if (grupoEmpresa == null) {
            throw new ObjetoNaoEncontradoException("Grupo Empresa n\u00e3o encontrado.");
        }
        List mensagensErro = grupoEmpresaRequestDto.validate();
        if (!mensagensErro.isEmpty()) {
            throw new RequisicaoInvalidaException(mensagensErro);
        }
        Status status = this.statusRepository.findByUuid(grupoEmpresaRequestDto.getStatusId());
        if (status == null) {
            throw new ObjetoNaoEncontradoException("Status informado n\u00e3o existe.");
        }
        String raizNumero = grupoEmpresaRequestDto.getRaiz().replaceAll("[^\\d]", "");
        GrupoEmpresa grupoExistente = this.grupoEmpresaRepository.findByRaiz(raizNumero);
        if (grupoExistente != null && !grupoExistente.getId().equals(grupoEmpresa.getId())) {
            throw new RequisicaoInvalidaException(List.of("Raiz j\u00e1 cadastrada em outro grupo."));
        }
        grupoEmpresa.setRaiz(grupoEmpresaRequestDto.getRaiz());
        grupoEmpresa.setNome(grupoEmpresaRequestDto.getNome());
        grupoEmpresa.setStatus(status);
        this.grupoEmpresaRepository.save((Object)grupoEmpresa);
    }
}

