/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.application.service;

import com.aec.api.application.dto.GrupoRequestDto;
import com.aec.api.application.dto.GrupoResponseDto;
import com.aec.api.application.service.exceptions.ObjetoNaoEncontradoException;
import com.aec.api.application.service.exceptions.RequisicaoInvalidaException;
import com.aec.api.application.service.interfaces.GrupoService;
import com.aec.api.domain.model.Grupo;
import com.aec.api.domain.model.GrupoRole;
import com.aec.api.domain.model.Role;
import com.aec.api.domain.repository.GrupoRepository;
import com.aec.api.domain.repository.GrupoRoleRepository;
import com.aec.api.domain.repository.RoleRepository;
import jakarta.transaction.Transactional;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GrupoServiceImpl
implements GrupoService {
    @Autowired
    private GrupoRepository grupoRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private GrupoRoleRepository grupoRoleRepository;

    public List<GrupoResponseDto> findAll() {
        List grupos = this.grupoRepository.findAllByOrderByDescricaoAsc();
        return grupos.stream().map(GrupoResponseDto::new).toList();
    }

    public void CriarGrupo(GrupoRequestDto grupoRequestDto) throws RequisicaoInvalidaException {
        Grupo grupo = grupoRequestDto.toEntity();
        List mensagensErro = grupoRequestDto.validate();
        if (!mensagensErro.isEmpty()) {
            throw new RequisicaoInvalidaException(mensagensErro);
        }
        this.grupoRepository.save((Object)grupo);
        this.adicionarRoles(grupo, grupoRequestDto.getRoles());
    }

    @Transactional
    public void AtualizarGrupo(String grupoId, GrupoRequestDto grupoRequestDto) throws ObjetoNaoEncontradoException, RequisicaoInvalidaException {
        Grupo grupoExistente = this.grupoRepository.findByUuid(grupoId);
        if (grupoExistente == null) {
            throw new ObjetoNaoEncontradoException("Grupo n\u00e3o encontrado com o UUID: " + grupoId);
        }
        List mensagensErro = grupoRequestDto.validate();
        if (!mensagensErro.isEmpty()) {
            throw new RequisicaoInvalidaException(mensagensErro);
        }
        grupoExistente.setDescricao(grupoRequestDto.getDescricao());
        this.grupoRepository.save((Object)grupoExistente);
        this.grupoRoleRepository.deleteByGrupoId(grupoExistente.getId());
        this.adicionarRoles(grupoExistente, grupoRequestDto.getRoles());
    }

    private void adicionarRoles(Grupo grupo, List<String> roles) {
        for (String role : roles) {
            Role roleEntity = this.roleRepository.findByUuid(role);
            if (roleEntity == null) continue;
            GrupoRole grupoRole = new GrupoRole();
            grupoRole.setGrupo(grupo);
            grupoRole.setRole(roleEntity);
            grupo.getGrupoRoles().add(grupoRole);
            this.grupoRoleRepository.save((Object)grupoRole);
        }
    }
}

