/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.application.service;

import com.aec.api.application.dto.CidadeResponseDto;
import com.aec.api.application.dto.EstadoResponseDto;
import com.aec.api.application.service.interfaces.LocalidadeService;
import com.aec.api.domain.model.Estado;
import com.aec.api.domain.repository.CidadeRepository;
import com.aec.api.domain.repository.EstadoRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocalidadeServiceImpl
implements LocalidadeService {
    @Autowired
    private EstadoRepository estadoRepository;
    @Autowired
    private CidadeRepository cidadeRepository;

    public List<EstadoResponseDto> listarEstados() {
        List estados = this.estadoRepository.findAllByOrderBySiglaAsc();
        return estados.stream().map(EstadoResponseDto::new).toList();
    }

    public List<CidadeResponseDto> listarCidades() {
        List cidades = this.cidadeRepository.findAllByOrderByCidadeAsc();
        return cidades.stream().map(CidadeResponseDto::new).toList();
    }

    public List<CidadeResponseDto> listarCidadesPorEstado(String estadoId) {
        Estado estado = this.estadoRepository.findByUuid(estadoId);
        if (estado == null) {
            return List.of();
        }
        List cidades = this.cidadeRepository.findByEstadoIdOrderByCidadeAsc(estado.getId());
        return cidades.stream().map(CidadeResponseDto::new).toList();
    }
}

