/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.application.service;

import com.aec.api.application.service.interfaces.MailService;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring6.SpringTemplateEngine;

@Service
public class MailServiceImpl
implements MailService {
    private final JavaMailSender mailSender;
    private final SpringTemplateEngine templateEngine;
    @Value(value="${spring.mail.username}")
    private String defaultFrom;

    public MailServiceImpl(JavaMailSender mailSender, SpringTemplateEngine templateEngine) {
        this.mailSender = mailSender;
        this.templateEngine = templateEngine;
    }

    public void enviarTexto(String para, String assunto, String texto) {
        SimpleMailMessage mensagem = new SimpleMailMessage();
        mensagem.setFrom(this.defaultFrom);
        mensagem.setTo(para);
        mensagem.setSubject(assunto);
        mensagem.setText(texto);
        this.mailSender.send(mensagem);
    }

    public void enviarHtml(String para, String assunto, String html, Map<String, Object> variables) throws MessagingException {
        Context ctx = new Context();
        ctx.setVariables(variables);
        String htmlProcessado = this.templateEngine.process(html, (IContext)ctx);
        MimeMessage mime = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mime, "UTF-8");
        helper.setFrom(this.defaultFrom);
        helper.setTo(para);
        helper.setSubject(assunto);
        helper.setText(htmlProcessado, true);
        this.mailSender.send(mime);
    }
}

