/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.application.service;

import com.aec.api.application.dto.AlterarSenhaRequest;
import com.aec.api.application.dto.UsuarioRequestDto;
import com.aec.api.application.dto.UsuarioResponseDto;
import com.aec.api.application.service.exceptions.CpfUsuarioExistenteException;
import com.aec.api.application.service.exceptions.EmailUsuarioExistenteException;
import com.aec.api.application.service.exceptions.ObjetoNaoEncontradoException;
import com.aec.api.application.service.exceptions.RequisicaoInvalidaException;
import com.aec.api.application.service.interfaces.MailService;
import com.aec.api.application.service.interfaces.UsuariosService;
import com.aec.api.domain.model.Grupo;
import com.aec.api.domain.model.Status;
import com.aec.api.domain.model.Usuario;
import com.aec.api.domain.model.UsuarioGrupo;
import com.aec.api.domain.repository.GrupoRepository;
import com.aec.api.domain.repository.StatusRepository;
import com.aec.api.domain.repository.UsuarioGrupoRepository;
import com.aec.api.domain.repository.UsuariosRepository;
import com.aec.api.shared.util.SenhaUtil;
import jakarta.mail.MessagingException;
import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UsuariosServiceImpl
implements UsuariosService,
UserDetailsService {
    @Autowired
    private UsuariosRepository usuariosRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private GrupoRepository grupoRepository;
    @Autowired
    private UsuarioGrupoRepository usuarioGrupoRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private MailService mailService;
    private static final String TEMPLATE_ENVIO_SENHA = "envio_de_senha.html";
    private static final String TEMPLATE_RECUPERAR_SENHA = "recuperar_senha.html";

    public void criarUsuario(UsuarioRequestDto usuarioRequestDto) throws RequisicaoInvalidaException, ObjetoNaoEncontradoException, EmailUsuarioExistenteException, CpfUsuarioExistenteException, MessagingException {
        List mensagensErro;
        if (usuarioRequestDto.getSenha() == null || usuarioRequestDto.getSenha().isEmpty()) {
            usuarioRequestDto.setSenha(SenhaUtil.gerarSenhaValida((int)6));
        }
        if (!(mensagensErro = usuarioRequestDto.validate()).isEmpty()) {
            throw new RequisicaoInvalidaException(mensagensErro);
        }
        Status status = this.statusRepository.findByUuid(usuarioRequestDto.getStatusId());
        if (status == null) {
            throw new ObjetoNaoEncontradoException("Status informado n\u00e3o existe.");
        }
        this.realizarValidacoesPreCriacao(usuarioRequestDto);
        Usuario usuario = usuarioRequestDto.toModel();
        usuario.setSenha(this.passwordEncoder.encode((CharSequence)usuario.getSenha()));
        usuario.setStatus(status);
        this.usuariosRepository.save((Object)usuario);
        this.adicionarGrupos(usuarioRequestDto.getGrupos(), usuario);
        HashMap<String, String> variaveis = new HashMap<String, String>();
        variaveis.put("nome", usuario.getNome());
        variaveis.put("senha", usuarioRequestDto.getSenha());
        variaveis.put("suporteEmail", "suporte@aecsst.com.br");
        variaveis.put("appUrl", "https://aecsst.com.br/");
        this.mailService.enviarHtml(usuario.getEmail(), "Cadastro de usu\u00e1rio", TEMPLATE_ENVIO_SENHA, variaveis);
    }

    private void adicionarGrupos(List<String> grupoUuids, Usuario usuario) {
        if (grupoUuids != null && !grupoUuids.isEmpty()) {
            for (String grupoUuid : grupoUuids) {
                Grupo grupo = this.grupoRepository.findByUuid(grupoUuid);
                if (grupo == null) continue;
                UsuarioGrupo usuarioGrupo = new UsuarioGrupo();
                usuarioGrupo.setUsuario(usuario);
                usuarioGrupo.setGrupo(grupo);
                this.usuarioGrupoRepository.save((Object)usuarioGrupo);
            }
        }
    }

    public UserDetails loadUserByUsername(String email) throws UsernameNotFoundException {
        Usuario usuario = this.usuariosRepository.findByEmail(email);
        if (usuario == null) {
            throw new UsernameNotFoundException(email);
        }
        return usuario;
    }

    public List<UsuarioResponseDto> listarUsuarios() {
        List usuarios = this.usuariosRepository.findAllByOrderByNomeAsc();
        return usuarios.stream().map(UsuarioResponseDto::new).toList();
    }

    @Transactional
    public void atualizarUsuario(String id, UsuarioRequestDto usuarioRequestDto) throws ObjetoNaoEncontradoException, EmailUsuarioExistenteException, CpfUsuarioExistenteException {
        Usuario usuario = this.usuariosRepository.findByUuid(id);
        this.realizarValidacoesPreAtualizacao(usuarioRequestDto, usuario);
        Status status = this.statusRepository.findByUuid(usuarioRequestDto.getStatusId());
        if (status == null) {
            throw new ObjetoNaoEncontradoException("Status informado n\u00e3o existe.");
        }
        usuario.setNome(usuarioRequestDto.getNome());
        usuario.setEmail(usuarioRequestDto.getEmail());
        usuario.setCargo(usuarioRequestDto.getCargo());
        usuario.setCpf(usuarioRequestDto.getCpf());
        usuario.setDataNascimento(usuarioRequestDto.getDataNascimento());
        usuario.setStatus(status);
        this.usuariosRepository.save((Object)usuario);
        this.usuarioGrupoRepository.deleteByUsuarioId(usuario.getId());
        this.adicionarGrupos(usuarioRequestDto.getGrupos(), usuario);
    }

    private void realizarValidacoesPreAtualizacao(UsuarioRequestDto usuarioRequestDto, Usuario usuario) throws ObjetoNaoEncontradoException, EmailUsuarioExistenteException, CpfUsuarioExistenteException {
        if (usuario == null) {
            throw new ObjetoNaoEncontradoException("Usu\u00e1rio n\u00e3o encontrado.");
        }
        Usuario usuarioExistente = this.usuariosRepository.findByEmail(usuarioRequestDto.getEmail());
        if (usuarioExistente != null && !usuarioExistente.getId().equals(usuario.getId())) {
            throw new EmailUsuarioExistenteException(usuarioExistente);
        }
        usuarioExistente = this.usuariosRepository.findByCpf(usuarioRequestDto.getCpf());
        if (usuarioExistente != null && !usuarioExistente.getId().equals(usuario.getId())) {
            throw new CpfUsuarioExistenteException(usuarioExistente.getCpf());
        }
    }

    private void realizarValidacoesPreCriacao(UsuarioRequestDto usuarioRequestDto) throws EmailUsuarioExistenteException, CpfUsuarioExistenteException {
        Usuario usuarioExistente = this.usuariosRepository.findByEmail(usuarioRequestDto.getEmail());
        if (usuarioExistente != null) {
            throw new EmailUsuarioExistenteException(usuarioExistente);
        }
        usuarioExistente = this.usuariosRepository.findByCpf(usuarioRequestDto.getCpf());
        if (usuarioExistente != null) {
            throw new CpfUsuarioExistenteException(usuarioExistente.getCpf());
        }
    }

    public void recuperarSenha(UsuarioRequestDto usuarioRequestDto) throws MessagingException {
        Usuario usuario = this.usuariosRepository.findByEmail(usuarioRequestDto.getEmail());
        if (usuario != null) {
            String novaSenha = SenhaUtil.gerarSenhaValida((int)6);
            usuario.setSenha(this.passwordEncoder.encode((CharSequence)novaSenha));
            this.usuariosRepository.save((Object)usuario);
            HashMap<String, String> variaveis = new HashMap<String, String>();
            variaveis.put("nome", usuario.getNome());
            variaveis.put("senha", novaSenha);
            variaveis.put("suporteEmail", "<suporte@aec.com.br>");
            variaveis.put("appUrl", "https://aecsst.com.br/");
            this.mailService.enviarHtml(usuario.getEmail(), "Recupera\u00e7\u00e3o de senha", TEMPLATE_RECUPERAR_SENHA, variaveis);
        }
    }

    public UsuarioResponseDto buscarMeuPerfil() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null || !auth.isAuthenticated()) {
            throw new AuthenticationCredentialsNotFoundException("N\u00e3o autenticado");
        }
        String email = auth.getName();
        Usuario usuario = this.usuariosRepository.findByEmail(email);
        if (usuario == null) {
            throw new UsernameNotFoundException(email);
        }
        return new UsuarioResponseDto(usuario);
    }

    public void alterarMinhaSenha(AlterarSenhaRequest alterarSenhaRequest) throws RequisicaoInvalidaException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null || !auth.isAuthenticated()) {
            throw new AuthenticationCredentialsNotFoundException("N\u00e3o autenticado");
        }
        if (!SenhaUtil.isValid((String)alterarSenhaRequest.getNovaSenha())) {
            throw new RequisicaoInvalidaException(List.of("A senha deve ter no m\u00ednimo 6 caracteres, incluindo ao menos uma letra mai\u00fascula, uma letra min\u00fascula, um n\u00famero e um caractere especial."));
        }
        String email = auth.getName();
        Usuario usuario = this.usuariosRepository.findByEmail(email);
        if (usuario == null) {
            throw new UsernameNotFoundException(email);
        }
        usuario.setSenha(this.passwordEncoder.encode((CharSequence)alterarSenhaRequest.getNovaSenha()));
        this.usuariosRepository.save((Object)usuario);
    }
}

