/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.infrastructure.config;

import com.aec.api.infrastructure.config.JWTConfig;
import io.jsonwebtoken.Claims;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class JWTAuthenticationFilter
extends OncePerRequestFilter {
    private final JWTConfig jwtConfig;

    public JWTAuthenticationFilter(JWTConfig jwtConfig) {
        this.jwtConfig = jwtConfig;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String token;
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Bearer ") && this.jwtConfig.isValid(token = header.replace("Bearer ", ""))) {
            String username = this.jwtConfig.getUsername(token);
            Claims claims = this.jwtConfig.getClaims(token);
            List roles = (List)claims.get("roles", List.class);
            List authorities = roles.stream().map(role -> new SimpleGrantedAuthority("ROLE_" + role)).collect(Collectors.toList());
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)username, null, authorities);
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

