/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.infrastructure.config;

import com.aec.api.infrastructure.config.JWTConfig;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class JWTAuthorizationFilter
extends BasicAuthenticationFilter {
    private JWTConfig jwtConfig;
    private UserDetailsService userDetailsService;

    public JWTAuthorizationFilter(AuthenticationManager authenticationManager, JWTConfig jwtConfig, UserDetailsService userDetailsService) {
        super(authenticationManager);
        this.jwtConfig = jwtConfig;
        this.userDetailsService = userDetailsService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        UsernamePasswordAuthenticationToken auth;
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Bearer ") && (auth = this.getAuthentication(header.substring(7))) != null) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private UsernamePasswordAuthenticationToken getAuthentication(String token) {
        if (this.jwtConfig.isValid(token)) {
            String email = this.jwtConfig.getUsername(token);
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(email);
            return new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
        }
        return null;
    }
}

