/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.infrastructure.config;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JWTConfig {
    @Value(value="${jwt.secret}")
    private String secret;
    @Value(value="${jwt.expiration}")
    private Long expiration;

    public String generateToken(String user, Map<String, Object> claims) {
        SecretKey secretKey = Keys.hmacShaKeyFor((byte[])this.secret.getBytes());
        Date now = new Date();
        return ((JwtBuilder)((JwtBuilder.BuilderClaims)Jwts.builder().subject(user).issuedAt(now).expiration(new Date(now.getTime() + this.expiration)).claims().add(claims)).and()).signWith((Key)secretKey, (SecureDigestAlgorithm)Jwts.SIG.HS512).compact();
    }

    public boolean isValid(String token) {
        Claims claims = this.getClaims(token);
        if (claims != null) {
            String username = claims.getSubject();
            Date expirationDate = claims.getExpiration();
            Date now = new Date();
            if (username != null && expirationDate != null && now.before(expirationDate)) {
                return true;
            }
        }
        return false;
    }

    public String getUsername(String token) {
        Claims claims = this.getClaims(token);
        if (claims != null) {
            return claims.getSubject();
        }
        return null;
    }

    public Claims getClaims(String token) {
        try {
            SecretKey secretKey = Keys.hmacShaKeyFor((byte[])this.secret.getBytes());
            return (Claims)Jwts.parser().verifyWith(secretKey).build().parseSignedClaims((CharSequence)token).getPayload();
        }
        catch (Exception e) {
            return null;
        }
    }
}

