/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.interfaces.exceptions;

import com.aec.api.application.service.exceptions.CpfUsuarioExistenteException;
import com.aec.api.application.service.exceptions.EmailUsuarioExistenteException;
import com.aec.api.application.service.exceptions.ObjetoNaoEncontradoException;
import com.aec.api.application.service.exceptions.RequisicaoInvalidaException;
import com.aec.api.application.service.exceptions.UsuarioOuSenhaInvalidoException;
import com.aec.api.interfaces.exceptions.ErroPadrao;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class RestExceptionHandler {
    @ExceptionHandler(value={ObjetoNaoEncontradoException.class})
    public ResponseEntity<ErroPadrao> handleObjetoNaoEncontradoException(ObjetoNaoEncontradoException ex, HttpServletRequest request) {
        ErroPadrao erro = new ErroPadrao();
        erro.setTimestamp(Instant.now());
        erro.setMessage(ex.getMessage());
        erro.setPath(request.getRequestURI());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)erro);
    }

    @ExceptionHandler(value={RequisicaoInvalidaException.class})
    public ResponseEntity<ErroPadrao> handleRequisicaoInvalidaException(RequisicaoInvalidaException ex, HttpServletRequest request) {
        ErroPadrao erro = new ErroPadrao();
        erro.setTimestamp(Instant.now());
        erro.setMessage(ex.getMessage());
        erro.setPath(request.getRequestURI());
        return ResponseEntity.badRequest().body((Object)erro);
    }

    @ExceptionHandler(value={EmailUsuarioExistenteException.class})
    public ResponseEntity<ErroPadrao> handleEmailUsuarioExistenteException(EmailUsuarioExistenteException ex, HttpServletRequest request) {
        ErroPadrao erro = new ErroPadrao();
        erro.setTimestamp(Instant.now());
        erro.setMessage(ex.getMessage());
        erro.setPath(request.getRequestURI());
        return ResponseEntity.badRequest().body((Object)erro);
    }

    @ExceptionHandler(value={UsuarioOuSenhaInvalidoException.class})
    public ResponseEntity<ErroPadrao> handleUsuarioOuSenhaInvalidoException(UsuarioOuSenhaInvalidoException ex, HttpServletRequest request) {
        ErroPadrao erro = new ErroPadrao();
        erro.setTimestamp(Instant.now());
        erro.setMessage(ex.getMessage());
        erro.setPath(request.getRequestURI());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)erro);
    }

    @ExceptionHandler(value={CpfUsuarioExistenteException.class})
    public ResponseEntity<ErroPadrao> handleCpfUsuarioExistenteException(CpfUsuarioExistenteException ex, HttpServletRequest request) {
        ErroPadrao erro = new ErroPadrao();
        erro.setTimestamp(Instant.now());
        erro.setMessage(ex.getMessage());
        erro.setPath(request.getRequestURI());
        return ResponseEntity.badRequest().body((Object)erro);
    }

    @ExceptionHandler(value={BadCredentialsException.class})
    public ResponseEntity<ErroPadrao> handleBadCredentialsException(BadCredentialsException ex, HttpServletRequest request) {
        ErroPadrao erro = new ErroPadrao();
        erro.setTimestamp(Instant.now());
        erro.setMessage("Usu\u00e1rio ou senha inv\u00e1lido.");
        erro.setPath(request.getRequestURI());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)erro);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErroPadrao> handleGenericException(Exception ex, HttpServletRequest request) {
        ErroPadrao erro = new ErroPadrao();
        erro.setTimestamp(Instant.now());
        erro.setMessage("Ocorreu um erro inesperado.");
        erro.setPath(request.getRequestURI());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)erro);
    }
}

