/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.interfaces.rest;

import com.aec.api.application.dto.CredenciaisRequestDto;
import com.aec.api.application.dto.TokenResponseDto;
import com.aec.api.application.service.exceptions.UsuarioOuSenhaInvalidoException;
import com.aec.api.application.service.interfaces.AuthService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
public class AuthController {
    @Autowired
    private AuthService authService;

    @PostMapping(value={"/login"})
    public ResponseEntity<TokenResponseDto> login(@RequestBody CredenciaisRequestDto credenciais) throws UsuarioOuSenhaInvalidoException {
        TokenResponseDto tokenDTO = this.authService.authenticate(credenciais);
        return ResponseEntity.ok().body((Object)tokenDTO);
    }

    @GetMapping(value={"/refresh"})
    public ResponseEntity<TokenResponseDto> refresh() throws UsuarioOuSenhaInvalidoException {
        TokenResponseDto tokenDTO = this.authService.refresh();
        return ResponseEntity.ok().body((Object)tokenDTO);
    }
}

