/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.interfaces.rest;

import com.aec.api.application.dto.EmpresaRequestDto;
import com.aec.api.application.dto.EmpresaResponseDto;
import com.aec.api.application.service.exceptions.ObjetoNaoEncontradoException;
import com.aec.api.application.service.exceptions.RequisicaoInvalidaException;
import com.aec.api.application.service.interfaces.EmpresaService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/empresas"})
public class EmpresaController {
    @Autowired
    private EmpresaService empresaService;

    @PreAuthorize(value="hasAnyRole('EMPRESA_ESCRITA')")
    @PostMapping
    public ResponseEntity<Void> criarEmpresa(@RequestBody EmpresaRequestDto empresaRequestDto) throws RequisicaoInvalidaException, ObjetoNaoEncontradoException {
        this.empresaService.criarEmpresa(empresaRequestDto);
        return ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="hasAnyRole('EMPRESA_ESCRITA', 'EMPRESA_LEITURA')")
    @GetMapping
    public ResponseEntity<List<EmpresaResponseDto>> listarEmpresas() {
        return ResponseEntity.ok((Object)this.empresaService.listarEmpresas());
    }

    @PreAuthorize(value="hasAnyRole('EMPRESA_ESCRITA', 'EMPRESA_LEITURA')")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<EmpresaResponseDto> buscarEmpresaPorId(@PathVariable String id) throws ObjetoNaoEncontradoException {
        return ResponseEntity.ok((Object)this.empresaService.buscarEmpresaPorId(id));
    }

    @PreAuthorize(value="hasAnyRole('EMPRESA_ESCRITA')")
    @PutMapping(value={"/{id}"})
    public ResponseEntity<Void> atualizarEmpresa(@PathVariable String id, @RequestBody EmpresaRequestDto empresaRequestDto) throws ObjetoNaoEncontradoException, RequisicaoInvalidaException {
        this.empresaService.atualizarEmpresa(id, empresaRequestDto);
        return ResponseEntity.noContent().build();
    }
}

