/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.interfaces.rest;

import com.aec.api.application.dto.GrupoRequestDto;
import com.aec.api.application.dto.GrupoResponseDto;
import com.aec.api.application.service.exceptions.ObjetoNaoEncontradoException;
import com.aec.api.application.service.exceptions.RequisicaoInvalidaException;
import com.aec.api.application.service.interfaces.GrupoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/grupos"})
public class GrupoController {
    @Autowired
    private GrupoService grupoService;

    @PreAuthorize(value="hasAnyRole('GRUPO_ESCRITA', 'GRUPO_LEITURA')")
    @GetMapping
    public ResponseEntity<List<GrupoResponseDto>> listarGrupos() {
        List groups = this.grupoService.findAll();
        return ResponseEntity.ok((Object)groups);
    }

    @PreAuthorize(value="hasRole('GRUPO_ESCRITA')")
    @PostMapping
    public ResponseEntity<Void> criarGrupo(@RequestBody GrupoRequestDto grupoRequestDto) throws RequisicaoInvalidaException {
        this.grupoService.CriarGrupo(grupoRequestDto);
        return ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="hasRole('GRUPO_ESCRITA')")
    @PutMapping(value={"/{id}"})
    public ResponseEntity<Void> atualizarGrupo(@PathVariable String id, @RequestBody GrupoRequestDto grupoRequestDto) throws RequisicaoInvalidaException, ObjetoNaoEncontradoException {
        this.grupoService.AtualizarGrupo(id, grupoRequestDto);
        return ResponseEntity.noContent().build();
    }
}

