/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.interfaces.rest;

import com.aec.api.application.dto.GrupoEmpresaRequestDto;
import com.aec.api.application.dto.GrupoEmpresaResponseDto;
import com.aec.api.application.service.exceptions.ObjetoNaoEncontradoException;
import com.aec.api.application.service.exceptions.RequisicaoInvalidaException;
import com.aec.api.application.service.interfaces.GrupoEmpresaService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/grupos-empresa"})
public class GrupoEmpresaController {
    @Autowired
    private GrupoEmpresaService grupoEmpresaService;

    @PreAuthorize(value="hasAnyRole('GRUPO_EMPRESA_ESCRITA')")
    @PostMapping
    public ResponseEntity<Void> criarGrupoEmpresa(@RequestBody GrupoEmpresaRequestDto grupoEmpresaRequestDto) throws RequisicaoInvalidaException, ObjetoNaoEncontradoException {
        this.grupoEmpresaService.criarGrupoEmpresa(grupoEmpresaRequestDto);
        return ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="hasAnyRole('GRUPO_EMPRESA_ESCRITA', 'GRUPO_EMPRESA_LEITURA')")
    @GetMapping
    public ResponseEntity<List<GrupoEmpresaResponseDto>> listarGruposEmpresa() {
        return ResponseEntity.ok((Object)this.grupoEmpresaService.listarGruposEmpresa());
    }

    @PreAuthorize(value="hasAnyRole('GRUPO_EMPRESA_ESCRITA', 'GRUPO_EMPRESA_LEITURA')")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<GrupoEmpresaResponseDto> buscarGrupoEmpresaPorId(@PathVariable(value="id") String id) throws ObjetoNaoEncontradoException {
        return ResponseEntity.ok((Object)this.grupoEmpresaService.buscarGrupoEmpresaPorId(id));
    }

    @PreAuthorize(value="hasAnyRole('GRUPO_EMPRESA_ESCRITA')")
    @PutMapping(value={"/{id}"})
    public ResponseEntity<Void> atualizarGrupoEmpresa(@PathVariable(value="id") String id, @RequestBody GrupoEmpresaRequestDto grupoEmpresaRequestDto) throws ObjetoNaoEncontradoException, RequisicaoInvalidaException {
        this.grupoEmpresaService.atualizarGrupoEmpresa(id, grupoEmpresaRequestDto);
        return ResponseEntity.noContent().build();
    }
}

