/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.interfaces.rest;

import com.aec.api.application.dto.CidadeResponseDto;
import com.aec.api.application.dto.EstadoResponseDto;
import com.aec.api.application.service.interfaces.LocalidadeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/localidades"})
public class LocalidadeController {
    @Autowired
    private LocalidadeService localidadeService;

    @GetMapping(value={"/estados"})
    public ResponseEntity<List<EstadoResponseDto>> listarEstados() {
        return ResponseEntity.ok((Object)this.localidadeService.listarEstados());
    }

    @GetMapping(value={"/cidades"})
    public ResponseEntity<List<CidadeResponseDto>> listarCidades() {
        return ResponseEntity.ok((Object)this.localidadeService.listarCidades());
    }

    @GetMapping(value={"/estados/{estadoId}/cidades"})
    public ResponseEntity<List<CidadeResponseDto>> listarCidadesPorEstado(@PathVariable(value="estadoId") String estadoId) {
        return ResponseEntity.ok((Object)this.localidadeService.listarCidadesPorEstado(estadoId));
    }
}

