/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.interfaces.rest;

import com.aec.api.application.dto.AlterarSenhaRequest;
import com.aec.api.application.dto.UsuarioRequestDto;
import com.aec.api.application.dto.UsuarioResponseDto;
import com.aec.api.application.service.exceptions.CpfUsuarioExistenteException;
import com.aec.api.application.service.exceptions.EmailUsuarioExistenteException;
import com.aec.api.application.service.exceptions.ObjetoNaoEncontradoException;
import com.aec.api.application.service.exceptions.RequisicaoInvalidaException;
import com.aec.api.application.service.interfaces.UsuariosService;
import jakarta.mail.MessagingException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/usuarios"})
public class UsuarioController {
    @Autowired
    private UsuariosService usuariosService;

    @PreAuthorize(value="hasAnyRole('USUARIO_ESCRITA')")
    @PostMapping
    public ResponseEntity<Void> criarUsuario(@RequestBody UsuarioRequestDto usuarioRequestDto) throws RequisicaoInvalidaException, ObjetoNaoEncontradoException, EmailUsuarioExistenteException, CpfUsuarioExistenteException, MessagingException {
        this.usuariosService.criarUsuario(usuarioRequestDto);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/recuperar-senha"})
    public ResponseEntity<Void> recuperarSenha(@RequestBody UsuarioRequestDto usuarioRequestDto) throws MessagingException {
        this.usuariosService.recuperarSenha(usuarioRequestDto);
        return ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="hasAnyRole('USUARIO_ESCRITA', 'USUARIO_LEITURA')")
    @GetMapping
    public ResponseEntity<List<UsuarioResponseDto>> listarUsuarios() {
        return ResponseEntity.ok((Object)this.usuariosService.listarUsuarios());
    }

    @PreAuthorize(value="hasAnyRole('USUARIO_ESCRITA')")
    @PutMapping(value={"/{id}"})
    public ResponseEntity<Void> atualizarUsuario(@PathVariable(value="id") String id, @RequestBody UsuarioRequestDto usuarioRequestDto) throws RequisicaoInvalidaException, ObjetoNaoEncontradoException, EmailUsuarioExistenteException, CpfUsuarioExistenteException {
        this.usuariosService.atualizarUsuario(id, usuarioRequestDto);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/meu-perfil"})
    public ResponseEntity<UsuarioResponseDto> buscarMeuPerfil() throws ObjetoNaoEncontradoException {
        return ResponseEntity.ok((Object)this.usuariosService.buscarMeuPerfil());
    }

    @PutMapping(value={"/alterar-minha-senha"})
    public ResponseEntity<Void> alterarMinhaSenha(@RequestBody AlterarSenhaRequest alterarSenhaRequest) throws RequisicaoInvalidaException {
        this.usuariosService.alterarMinhaSenha(alterarSenhaRequest);
        return ResponseEntity.noContent().build();
    }
}

