/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.shared.util;

public class CNPJUtil {
    public static boolean isValid(String cnpj) {
        if (cnpj == null || cnpj.isEmpty()) {
            return false;
        }
        String cnpjNumeros = cnpj.replaceAll("[^\\d]", "");
        if (cnpjNumeros.length() != 14) {
            return false;
        }
        if (cnpjNumeros.matches("(\\d)\\1{13}")) {
            return false;
        }
        try {
            int primeiroDigito;
            int soma = 0;
            int peso = 2;
            for (int i = 11; i >= 0; --i) {
                int digito = Character.getNumericValue(cnpjNumeros.charAt(i));
                soma += digito * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            int n = primeiroDigito = soma % 11 < 2 ? 0 : 11 - soma % 11;
            if (primeiroDigito != Character.getNumericValue(cnpjNumeros.charAt(12))) {
                return false;
            }
            soma = 0;
            peso = 2;
            for (int i = 12; i >= 0; --i) {
                int digito = Character.getNumericValue(cnpjNumeros.charAt(i));
                soma += digito * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            int segundoDigito = soma % 11 < 2 ? 0 : 11 - soma % 11;
            return segundoDigito == Character.getNumericValue(cnpjNumeros.charAt(13));
        }
        catch (Exception e) {
            return false;
        }
    }
}

