/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.shared.util;

import java.util.List;

public final class CPFUtil {
    private static List<String> cpfsInvalidos = List.of("00000000000", "11111111111", "22222222222", "33333333333", "44444444444", "55555555555", "66666666666", "77777777777", "88888888888", "99999999999");

    public static boolean isValid(String cpf) {
        if (cpf == null) {
            return false;
        }
        if ((cpf = cpf.replaceAll("[^\\d]", "")).length() != 11 || cpfsInvalidos.contains(cpf)) {
            return false;
        }
        int soma = 0;
        for (int i = 0; i < 9; ++i) {
            soma += (cpf.charAt(i) - 48) * (10 - i);
        }
        int primeiroDigito = 11 - soma % 11;
        if (primeiroDigito >= 10) {
            primeiroDigito = 0;
        }
        if (primeiroDigito != cpf.charAt(9) - 48) {
            return false;
        }
        soma = 0;
        for (int i = 0; i < 10; ++i) {
            soma += (cpf.charAt(i) - 48) * (11 - i);
        }
        int segundoDigito = 11 - soma % 11;
        if (segundoDigito >= 10) {
            segundoDigito = 0;
        }
        return segundoDigito == cpf.charAt(10) - 48;
    }
}

