/*
 * Decompiled with CFR 0.152.
 */
package com.aec.api.shared.util;

import java.security.SecureRandom;

public final class SenhaUtil {
    private static final String UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LOWER = "abcdefghijklmnopqrstuvwxyz";
    private static final String DIGITS = "0123456789";
    private static final String SPECIAL = "!@#$%^&*()-_=+[]{}|;:'\",.<>?/`~";
    private static final String ALL = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()-_=+[]{}|;:'\",.<>?/`~";
    private static final SecureRandom RANDOM = new SecureRandom();

    public static boolean isValid(String senha) {
        if (senha == null || senha.length() < 6) {
            return false;
        }
        boolean hasUppercase = senha.chars().anyMatch(Character::isUpperCase);
        boolean hasLowercase = senha.chars().anyMatch(Character::isLowerCase);
        boolean hasDigit = senha.chars().anyMatch(Character::isDigit);
        boolean hasSpecial = senha.chars().anyMatch(ch -> SPECIAL.indexOf(ch) >= 0);
        return hasUppercase && hasLowercase && hasDigit && hasSpecial;
    }

    public static String gerarSenhaValida(int tamanho) {
        if (tamanho < 6) {
            throw new IllegalArgumentException("Tamanho m\u00ednimo \u00e9 6");
        }
        StringBuilder senha = new StringBuilder(tamanho);
        senha.append(UPPER.charAt(RANDOM.nextInt(UPPER.length())));
        senha.append(LOWER.charAt(RANDOM.nextInt(LOWER.length())));
        senha.append(DIGITS.charAt(RANDOM.nextInt(DIGITS.length())));
        senha.append(SPECIAL.charAt(RANDOM.nextInt(SPECIAL.length())));
        for (int i = 4; i < tamanho; ++i) {
            senha.append(ALL.charAt(RANDOM.nextInt(ALL.length())));
        }
        char[] senhaArray = senha.toString().toCharArray();
        for (int i = senhaArray.length - 1; i > 0; --i) {
            int j = RANDOM.nextInt(i + 1);
            char temp = senhaArray[i];
            senhaArray[i] = senhaArray[j];
            senhaArray[j] = temp;
        }
        return new String(senhaArray);
    }
}

